<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Desabilitar exibição de erros (para produção)
ini_set("display_errors", 0);
ini_set("display_startup_errors", 0);
error_reporting(32767);

// Conectar ao banco de dados SQLite
$db = new SQLite3("./api/data/.boxbr_update.db");

// Nome da tabela
$table_name = "update_apk";

// Corrigir erro de digitação em 'playstore2 TEXT'
$db->exec("CREATE TABLE IF NOT EXISTS " . $table_name . " (
    id INTEGER PRIMARY KEY,
    apkname1 TEXT,
    version1 TEXT,
    packager1 TEXT,
    apkurl1 TEXT,
    playstore1 TEXT,
    apkname2 TEXT,
    version2 TEXT,
    packager2 TEXT,
    apkurl2 TEXT,
    playstore2 TEXT
)");

// Verificar o número de registros na tabela
$rows = $db->query("SELECT COUNT(*) as count FROM " . $table_name);
$row = $rows->fetchArray();
$numRows = $row["count"];

// Inserir registro padrão se a tabela estiver vazia
if($numRows == 0) {
    $db->exec("INSERT INTO " . $table_name . " (apkname1, version1, packager1, apkurl1, playstore1, apkname2, version2, packager2, apkurl2, playstore2) 
              VALUES ('apkname1', 'version1', 'packager1', 'apkurl1', 'playstore1', 'apkname2', 'version2', 'packager2', 'apkurl2', 'playstore2')");
}

// Selecionar o registro com id=1
$res = $db->query("SELECT * FROM " . $table_name . " WHERE id='1'");
$rowU = $res->fetchArray();

// Verificar se o formulário foi submetido
if(isset($_POST["submit"])) {
    // Preparar a consulta UPDATE usando *prepared statements*
    $stmt = $db->prepare("UPDATE " . $table_name . " SET 
                            apkname1 = :apkname1, 
                            version1 = :version1, 
                            packager1 = :packager1, 
                            apkurl1 = :apkurl1, 
                            playstore1 = :playstore1, 
                            apkname2 = :apkname2, 
                            version2 = :version2, 
                            packager2 = :packager2, 
                            apkurl2 = :apkurl2, 
                            playstore2 = :playstore2 
                          WHERE id = :id");
    
    // Vincular os valores dos parâmetros
    $stmt->bindValue(':apkname1', $_POST["apkname1"], SQLITE3_TEXT);
    $stmt->bindValue(':version1', $_POST["version1"], SQLITE3_TEXT);
    $stmt->bindValue(':packager1', $_POST["packager1"], SQLITE3_TEXT);
    $stmt->bindValue(':apkurl1', $_POST["apkurl1"], SQLITE3_TEXT);
    $stmt->bindValue(':playstore1', $_POST["playstore1"], SQLITE3_TEXT);
    $stmt->bindValue(':apkname2', $_POST["apkname2"], SQLITE3_TEXT);
    $stmt->bindValue(':version2', $_POST["version2"], SQLITE3_TEXT);
    $stmt->bindValue(':packager2', $_POST["packager2"], SQLITE3_TEXT);
    $stmt->bindValue(':apkurl2', $_POST["apkurl2"], SQLITE3_TEXT);
    $stmt->bindValue(':playstore2', $_POST["playstore2"], SQLITE3_TEXT);
    $stmt->bindValue(':id', 1, SQLITE3_INTEGER); // id=1 fixo conforme consulta

    // Executar a consulta
    $stmt->execute();
    
    // Fechar a conexão com o banco de dados
    $db->close();
    
    // Redirecionar para 'update.php'
    header("Location: update.php");
    exit();
}

// Incluir o cabeçalho da página
include "includes/header.php";

// Exibir mensagem de feedback, se existir
if(isset($_GET["message"])) {
    echo '<div class="alert alert-info bg-primary py-3" id="flash-msg">';
    echo '<h4 align="center" class="m-0 font-weight-bold text-white">';
    echo '<i class="icon fa fa-check"></i><b> ' . htmlspecialchars($_GET["message"]) . ' </b>';
    echo '</h4></div>';
}
?>
<!-- [ Main Content ] start -->
<div class="pcoded-main-container">
    <div class="pcoded-wrapper">
        <div class="pcoded-content">
            <div class="pcoded-inner-content">
                <div class="main-body">
                    <div class="page-wrapper">
                        <!-- [ Main Content ] start -->
                        <div class="row">
                            <!-- Column -->
                            <div class="col-lg-12">
                                <div class="card mb-4">
                                    <div class="card-header bg-primary py-3">
                                        <h4 align="center" class="m-0 font-weight-bold text-white">
                                            <i class="fas fa-cloud-upload-alt" style="font-size:20px">&nbsp;&nbsp;</i>Settings Update
                                        </h4>
                                    </div>
                                    <div class="card-body wow-bg" id="formBg">
                                        <h4 class="colorboard">Settings Update APK 1</h4>
                                        <form method="post">
                                            <div class="input-group mb-4">
                                                <input type="text" class="form-control textbox-dg" placeholder="APK Name" name="apkname1" value="<?php echo htmlspecialchars($rowU["apkname1"]); ?>" required>
                                            </div>
                                            <div class="input-group mb-3">
                                                <input type="text" class="form-control textbox-dg" placeholder="Version Number" name="version1" value="<?php echo htmlspecialchars($rowU["version1"]); ?>" required>
                                            </div>
                                            <!--
                                            <div class="input-group mb-3">
                                                <input type="text" class="form-control textbox-dg" placeholder="Package name" name="packager1" value="<?php echo htmlspecialchars($rowU["packager1"]); ?>" required>
                                            </div>
                                            -->
                                            <div class="input-group mb-4">
                                                <input type="text" class="form-control textbox-dg" placeholder="Download URL" name="apkurl1" value="<?php echo htmlspecialchars($rowU["apkurl1"]); ?>" required>
                                            </div>
                                            <div class="input-group mb-4">
                                                <input type="text" class="form-control textbox-dg" placeholder="Playstore URL" name="playstore1" value="<?php echo htmlspecialchars($rowU["playstore1"]); ?>" required>
                                            </div>
                                            
                                            <div class="row">
                                                <div class="col">
                                                    <a href="#" parametro="<?php echo _obfuscated_01_($rowU["apkurl1"], "300"); ?>" class="abrirModal btn btn-primary btn-block logn-btn">
                                                        <img link="<?php echo htmlspecialchars($rowU["apkurl1"]); ?>" name="*APK <?php echo htmlspecialchars($rowU["apkname1"]); ?> QRCode Url Download:* " width="80" height="80" style="-webkit-user-select: none; max-width:80px; max-height:80px" src="<?php echo _obfuscated_01_($rowU["apkurl1"], "300"); ?>">
                                                        <img width="200" height="80" style="-webkit-user-select: none; max-width:300px; max-height:80px" src="./assets/images/apklink.jpg">
                                                        <br> Get QRCode Download Url Link APK: ( <?php echo htmlspecialchars($rowU["apkname1"]); ?> )
                                                    </a>
                                                </div>
                                                <div class="col">
                                                    <a href="#" parametro="<?php echo _obfuscated_01_($rowU["playstore1"], "300"); ?>" class="abrirModal btn btn-primary btn-block logn-btn">
                                                        <img link="<?php echo htmlspecialchars($rowU["playstore1"]); ?>" name="*APK <?php echo htmlspecialchars($rowU["apkname1"]); ?> QRCode Playstore Download:* " width="80" height="80" style="-webkit-user-select: none; max-width:80px; max-height:80px" src="<?php echo _obfuscated_01_($rowU["playstore1"], "300"); ?>">
                                                        <img width="200" height="80" style="-webkit-user-select: none; max-width:300px; max-height:80px" src="./assets/images/playstore.jpg">
                                                        <br> Get QRCode Download Playstore APK: ( <?php echo htmlspecialchars($rowU["apkname1"]); ?> )
                                                    </a>
                                                </div>
                                            </div>
                                            
                                            <div class="row">
                                                <h4 class="colorboard">Settings Update APK 2</h4>
                                                <div class="input-group mb-4">
                                                    <input type="text" class="form-control textbox-dg" placeholder="APK Name" name="apkname2" value="<?php echo htmlspecialchars($rowU["apkname2"]); ?>" required>
                                                </div>
                                                <div class="input-group mb-3">
                                                    <input type="text" class="form-control textbox-dg" placeholder="Version Number" name="version2" value="<?php echo htmlspecialchars($rowU["version2"]); ?>" required>
                                                </div>
                                                <!--
                                                <div class="input-group mb-3">
                                                    <input type="text" class="form-control textbox-dg" placeholder="Package name" name="packager2" value="<?php echo htmlspecialchars($rowU["packager2"]); ?>" required>
                                                </div>
                                                -->
                                                <div class="input-group mb-4">
                                                    <input type="text" class="form-control textbox-dg" placeholder="Download URL" name="apkurl2" value="<?php echo htmlspecialchars($rowU["apkurl2"]); ?>" required>
                                                </div>
                                                <div class="input-group mb-4">
                                                    <input type="text" class="form-control textbox-dg" placeholder="Playstore URL" name="playstore2" value="<?php echo htmlspecialchars($rowU["playstore2"]); ?>" required>
                                                </div>
                                                
                                                <div class="row">
                                                    <div class="col">
                                                        <a href="#" parametro="<?php echo _obfuscated_01_($rowU["apkurl2"], "300"); ?>" class="abrirModal btn btn-primary btn-block logn-btn">
                                                            <img link="<?php echo htmlspecialchars($rowU["apkurl2"]); ?>" name="*APK <?php echo htmlspecialchars($rowU["apkname2"]); ?> QRCode Url Download:* " width="80" height="80" style="-webkit-user-select: none; max-width:80px; max-height:80px" src="<?php echo _obfuscated_01_($rowU["apkurl2"], "300"); ?>">
                                                            <img width="200" height="80" style="-webkit-user-select: none; max-width:300px; max-height:80px" src="./assets/images/apklink.jpg">
                                                            <br> Get QRCode Download Url Link APK: ( <?php echo htmlspecialchars($rowU["apkname2"]); ?> )
                                                        </a>
                                                    </div>
                                                    <div class="col">
                                                        <a href="#" parametro="<?php echo _obfuscated_01_($rowU["playstore2"], "300"); ?>" class="abrirModal btn btn-primary btn-block logn-btn">
                                                            <img link="<?php echo htmlspecialchars($rowU["playstore2"]); ?>" name="*APK <?php echo htmlspecialchars($rowU["apkname2"]); ?> QRCode Playstore Download:* " width="80" height="80" style="-webkit-user-select: none; max-width:80px; max-height:80px" src="<?php echo _obfuscated_01_($rowU["playstore2"], "300"); ?>">
                                                            <img width="200" height="80" style="-webkit-user-select: none; max-width:300px; max-height:80px" src="./assets/images/playstore.jpg">
                                                            <br> Get QRCode Download Playstore APK: ( <?php echo htmlspecialchars($rowU["apkname2"]); ?> )
                                                        </a>
                                                    </div>
                                                </div>
                                                
                                                <div align="center" class="form-group">
                                                    <br>
                                                    <br>
                                                    <button class="btn btn-danger" name="submit" type="submit">
                                                        <span class="icon text-white-50"><i class="fa fa-save"></i>&nbsp;&nbsp;</span>
                                                        <span class="text"> Save Settings</span>
                                                    </button>
                                                </div>
                                        </form> 
                                    </div>
                                </div>
                            </div>
                            <!-- Column -->
                        </div>
                    </div>
                    <!-- ============================================================== -->
                    <!-- End Container fluid  -->
                    <!-- ============================================================== -->
                </div>
                <!-- ============================================================== -->
                <!-- End Page wrapper  -->
                <!-- ============================================================== -->
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel">Apk Download QR Code Image View</h4>
        <button type="button" class="close btn-danger" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body text-center">
        <img src="" />
        <input class="copy" type="hidden" id="codelink" value="" />
        <input class="copyurl" type="hidden" id="urllink" value="" />
      </div>
      <div class="modal-footer">
          <a href="" target="_blank" class="link1 btn btn-success btn-icon-split">
              <span class="icon text-white-50"><i class="fa fa-paper-plane"></i></span>&nbsp;&nbsp;
              <span class="text"> Send to Whatsapp </span>
          </a>
          
          <button onclick="myFunction()" id="btncopy" class="btncopy btn btn-primary btn-icon-split">
              <span class="icon text-white-50"><i class="fa fa-copy"></i></span>&nbsp;&nbsp;
              <span class="text"> Copy Url Link </span>
          </button>
          
          <button onclick="myFunction2()" id="btncopy2" class="btncopy2 btn btn-warning btn-icon-split">
              <span class="icon text-white-50"><i class="fa fa-copy"></i></span>&nbsp;&nbsp;
              <span class="text"> Copy QR Image Link </span>
          </button>
          &nbsp;&nbsp;&nbsp;&nbsp;
          <button class="btn btn-danger btn-icon-split" data-dismiss="modal">
              <span class="icon text-white-50"><i class="fa fa-times"></i></span>&nbsp;&nbsp;
              <span class="text"> Close </span>
          </button>
      </div>
    </div>
  </div>
</div>   

<script type="text/javascript">
    $(".abrirModal").click(function() {

        var url = $(this).find("img").attr("src");
        var url2 = $(this).find("img").attr("link");
        var urln = $(this).find("img").attr("name");
        var urlw =  urln  + ' \n\n *Url link:* ' + url2 + '  \n\n *QR image link:* ' + url;
        var LinkTextToShare = 'https://api.whatsapp.com/send?phone=&text=' + encodeURIComponent(urlw) ;
        
        //alert(url)
        
        $("#myModal img").attr("src", url);
        $("#myModal a.link1").attr("href", LinkTextToShare);
        $("#myModal a.link2").attr("href", url);
        $("#myModal input.copy").attr("value", url);
        $("#myModal input.copyurl").attr("value", url2);
        $("#myModal").modal("show");
    });
</script>

<script>
function myFunction() {

    var copyText = document.getElementById("urllink");
    copyText.value

    $("#myModal input.copyurl").attr("type", "text"); 
    copyText.select();
    document.execCommand("copy");
    //this function copies the text of the input with ID "copy"

    //alert(copyText.value);
    
    $("#myModal input.copyurl").attr("type", "hidden");
    
    text = '<span class="icon text-white-50"><i class="fa fa-copy"></i></span>&nbsp;&nbsp;<span class="text"> Link Copied OK! </span>';
    textToChangeBackTo = '<span class="icon text-white-50"><i class="fa fa-copy"></i></span>&nbsp;&nbsp;<span class="text"> Copy Url Link </span>';
    
    document.getElementById("btncopy").innerHTML = text;
    setTimeout(function() { document.getElementById("btncopy").innerHTML = textToChangeBackTo; }, 5000);
}

function myFunction2() {

    var copyText = document.getElementById("codelink");
    copyText.value

    $("#myModal input.copy").attr("type", "text"); 
    copyText.select();
    document.execCommand("copy");
    //this function copies the text of the input with ID "copy"

    //alert(copyText.value);
    
    $("#myModal input.copy").attr("type", "hidden");
    
    text = '<span class="icon text-white-50"><i class="fa fa-copy"></i></span>&nbsp;&nbsp;<span class="text">  QR Image Copied OK! </span>';
    textToChangeBackTo = '<span class="icon text-white-50"><i class="fa fa-copy"></i></span>&nbsp;&nbsp;<span class="text"> Copy QR Image Link </span>';
    
    document.getElementById("btncopy2").innerHTML = text;
    setTimeout(function() { document.getElementById("btncopy2").innerHTML = textToChangeBackTo; }, 5000);
}
</script>   

<?php
// Incluir funções ou footer
include "includes/functions.php";

// Definir a função _obfuscated_01_
function _obfuscated_01_($url, $size)
{
    return "http://chart.apis.google.com/chart?cht=qr&chl=" . urlencode($url) . "&chs=" . $size . "x" . $size . "&chtt=H&choe=UTF-8";
}
?>
