<?php
$db = new SQLite3("./api/data/.boxbr_snoop.db");

if (isset($_GET["delete"])) {
    if ($_GET["delete"] === "all") {
        $db->exec("DELETE FROM logs");
    } else {
        $id = intval($_GET["delete"]);
        $db->exec("DELETE FROM logs WHERE id = $id");
    }
    header("Location: snoop.php");
    exit;
}

$res = $db->query("SELECT * FROM logs");

include "includes/header.php";
require "includes/functions.php";
?>

<!-- Modals -->
<div class="modal fade" id="confirm-deleteall" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
   <div class="modal-dialog">
       <div class="modal-content">
           <div class="modal-header">
               <h2>Confirm</h2>
           </div>
           <div class="modal-body">
               Do you really want to delete all logs?
           </div>
           <div class="modal-footer">
               <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
               <a class="btn btn-danger btn-ok" href="#">Delete All Logs</a>
           </div>
       </div>
   </div>
</div>

<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
   <div class="modal-dialog">
       <div class="modal-content">
           <div class="modal-header">
               <h2>Confirm</h2>
           </div>
           <div class="modal-body">
               Do you really want to delete this log?
           </div>
           <div class="modal-footer">
               <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
               <a class="btn btn-danger btn-ok" href="#">Delete</a>
           </div>
       </div>
   </div>
</div>

<script>
$('#confirm-delete').on('show.bs.modal', function(e) {
   $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
});
$('#confirm-deleteall').on('show.bs.modal', function(e) {
   $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
});
</script>
<!-- Fim dos Modals -->

<div class="pcoded-main-container">
   <div class="pcoded-wrapper">
      <div class="pcoded-content">
         <div class="pcoded-inner-content">
            <div class="main-body">
               <div class="page-wrapper">
                  <div class="row">
                     <div class="col-lg-12">
                        <div class="card mb-4">
                           <div class="card-header bg-primary py-3">
                              <h4 align="center" class="m-0 font-weight-bold text-white">
                                 <i class="fas fa-eye" style="font-size:20px"></i>&nbsp;&nbsp;Snooping Logs
                              </h4>
                           </div>
                           <div class="card-body">
                              <div class="input-group" style="margin-bottom: 20px;">
                                 <a class="btn btn-danger text-white-20" href="#" data-href="./snoop.php?delete=all" data-toggle="modal" data-target="#confirm-deleteall">
                                    <span class="icon text-white-20">
                                       <i class="fa fa-user-trash" style="font-size:24px;color:red;"></i>
                                       Delete All
                                    </span>
                                 </a>
                              </div>

                              <div class="table-responsive">
                                 <table class="table table-striped table-sm table-bordered">
                                    <thead align="center" class="text-primary">
                                       <tr>
                                          <th>Date</th>
                                          <th>Type Access</th>
                                          <th>IP Address</th>
                                          <th>ISP</th>
                                          <th>State</th>
                                          <th>Country</th>
                                          <th>Delete</th>
                                       </tr>
                                    </thead>
                                    <tbody align="center">
                                       <?php while ($row = $res->fetchArray(SQLITE3_ASSOC)): ?>
                                       <tr class="text-primary">
                                          <td><?php echo htmlspecialchars($row["date"]); ?></td>
                                          <td><?php echo htmlspecialchars($row["access"]); ?></td>
                                          <td><?php echo htmlspecialchars($row["ipaddress"]); ?></td>
                                          <td><?php echo htmlspecialchars($row["isp"]); ?></td>
                                          <td><?php echo htmlspecialchars($row["state"]); ?></td>
                                          <td>
                                             <?php if (empty($row["country"])): ?>
                                                Unknown
                                             <?php else: ?>
                                                <img src="./assets/images/flags/<?php echo strtolower($row["country"]); ?>.png" alt="Flag"> 
                                                <?php echo htmlspecialchars($row["country"]); ?>
                                             <?php endif; ?>
                                          </td>
                                          <td>
                                             <a class="btn btn-danger text-white-15" href="#" data-href="./snoop.php?delete=<?php echo intval($row["id"]); ?>" data-toggle="modal" data-target="#confirm-delete">
                                                <span class="icon text-white-20"><i class="fa fa-trash"></i></span>
                                             </a>
                                          </td>
                                       </tr>
                                       <?php endwhile; ?>
                                    </tbody>
                                 </table>
                              </div>

                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
