<?php
// Função para obter o IP do visitante
function getClientIP() {
    $ip = 'undefined';
    if (isset($_SERVER)) {
        $ip = $_SERVER['REMOTE_ADDR'];
        if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        }
    } else {
        $ip = getenv('REMOTE_ADDR');
        if (getenv('HTTP_X_FORWARDED_FOR')) {
            $ip = getenv('HTTP_X_FORWARDED_FOR');
        } elseif (getenv('HTTP_CLIENT_IP')) {
            $ip = getenv('HTTP_CLIENT_IP');
        }
    }
    return htmlspecialchars($ip, ENT_QUOTES, 'UTF-8');
}

// Função para obter o sistema operacional
function getOS() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    $os = 'Unknown OS Platform';
    $osArray = [
        '/windows nt 10/i' => 'Windows 10',
        '/windows nt 6.3/i' => 'Windows 8.1',
        '/windows nt 6.2/i' => 'Windows 8',
        '/windows nt 6.1/i' => 'Windows 7',
        '/windows nt 6.0/i' => 'Windows Vista',
        '/windows nt 5.2/i' => 'Windows Server 2003/XP x64',
        '/windows nt 5.1/i' => 'Windows XP',
        '/windows xp/i' => 'Windows XP',
        '/windows nt 5.0/i' => 'Windows 2000',
        '/windows me/i' => 'Windows ME',
        '/win98/i' => 'Windows 98',
        '/win95/i' => 'Windows 95',
        '/win16/i' => 'Windows 3.11',
        '/macintosh|mac os x/i' => 'Mac OS X',
        '/mac_powerpc/i' => 'Mac OS 9',
        '/linux/i' => 'Linux',
        '/ubuntu/i' => 'Ubuntu',
        '/iphone/i' => 'iPhone',
        '/ipod/i' => 'iPod',
        '/ipad/i' => 'iPad',
        '/android/i' => 'Android',
        '/blackberry/i' => 'BlackBerry',
        '/webos/i' => 'Mobile'
    ];
    foreach ($osArray as $regex => $value) {
        if (preg_match($regex, $userAgent)) {
            $os = $value;
        }
    }
    return $os;
}

// Função para obter o navegador
function getBrowser() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    $browser = 'Unknown Browser';
    $browserArray = [
        '/msie/i' => 'Internet Explorer',
        '/Trident/i' => 'Internet Explorer',
        '/firefox/i' => 'Firefox',
        '/safari/i' => 'Safari',
        '/chrome/i' => 'Chrome',
        '/edge/i' => 'Edge',
        '/opera/i' => 'Opera',
        '/netscape/i' => 'Netscape',
        '/maxthon/i' => 'Maxthon',
        '/konqueror/i' => 'Konqueror',
        '/ubrowser/i' => 'UC Browser',
        '/mobile/i' => 'Handheld Browser'
    ];
    foreach ($browserArray as $regex => $value) {
        if (preg_match($regex, $userAgent)) {
            $browser = $value;
        }
    }
    return $browser;
}

// Função para obter o tipo de dispositivo
function getDevice() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    $deviceType = 'Computer';
    $tabletArray = ['/tablet|ipad|playbook/i', '/android(?!.*(mobi|opera mini))/i'];
    $mobileArray = ['/up.browser|up.link|mmp|symbian|smartphone|midp|wap|phone|android|iemobile/i'];

    $isTablet = false;
    $isMobile = false;

    foreach ($tabletArray as $regex) {
        if (preg_match($regex, strtolower($userAgent))) {
            $isTablet = true;
            break;
        }
    }

    foreach ($mobileArray as $regex) {
        if (preg_match($regex, strtolower($userAgent))) {
            $isMobile = true;
            break;
        }
    }

    if ($isTablet) {
        $deviceType = 'Tablet';
    } elseif ($isMobile) {
        $deviceType = 'Mobile';
    }

    return $deviceType;
}

// Função para verificar se o visitante usa o Tor
function isUsingTor() {
    $host = gethostbyname(getClientIP() . '.' . $_SERVER['SERVER_PORT'] . '.' . getClientIP() . '.' . 'ip-port.exitlist.torproject.org');
    return $host === '127.0.0.2' ? 'True' : 'False';
}

// Obter IP do visitante e detalhes
$ip = getClientIP();
$details = json_decode(file_get_contents("https://ipinfo.io/{$ip}/json"));
$country = $details->country ?? 'Unknown';
$state = $details->region ?? 'Unknown';
$city = $details->city ?? 'Unknown';
$isp = preg_replace("/AS\\d{1,}\\s/", "", $details->org ?? 'Unknown');
$loc = $details->loc ?? 'Unknown';

// Configurar o fuso horário
date_default_timezone_set("Europe/London");

// Formatar o log
$logContent = "---------------------------------------------\n" .
              "[TOA] " . date("d-m-Y H:i:s") . "\n" .
              "[IPV6] " . getClientIP() . "\n" .
              "[Country] " . $country . "\n" .
              "[City] " . $city . "\n" .
              "[State] " . $state . "\n" .
              "[ISP] " . $isp . "\n" .
              "[Location] " . $loc . "\n" .
              "[UA] " . $_SERVER["HTTP_USER_AGENT"] . "\n" .
              "[OS] " . getOS() . "\n" .
              "[Browser] " . getBrowser() . "\n" .
              "[Device] " . getDevice() . "\n" .
              "[Tor Browser] " . isUsingTor() . "\n";

// Nome do arquivo de log
$logname = date("d-m-Y H:i:s") . ".log";

// Gravar o log
$file = "snoop/{$logname}";
file_put_contents($file, $logContent . PHP_EOL, FILE_APPEND);

// Gerar HTML para a página
echo '<title>Enter Panel - Alert!</title>
<link rel="stylesheet" href="assets/css/style2.css">
<style>
@import url("https://fonts.googleapis.com/css?family=Share+Tech+Mono|Montserrat:700");
* {
    margin: 0;
    padding: 0;
    border: 0;
    font-size: 100%;
    font: inherit;
    vertical-align: baseline;
    box-sizing: border-box;
    color: #fffff;
}
body {
    background-image: url(assets/images/lock.jpg);
    background-size: 100% 100%;
    background-attachment: fixed;
    background-position: center;
    background-color: black;
    background-repeat: no-repeat;
}
.container {
    color: white;
    border-radius: 1em;
    padding: 1em;
    position: absolute;
    top: 50%;
    left: 50%;
    margin-right: -50%;
    transform: translate(-50%, -50%);
}
</style>
<body>
<div class="container">
    <h1><font color="#c75c5c">Welcome!</font></h1>
    <h3><font color="#00f4c1">You are visiting this panel.</font></h3>
    <h4><font color="#e6b74b">[ Your information has been collected. ]</font></h4>
    <h3><font color="#7e7e7e">You are <font color="#c75c5c">' . getDevice() . '</font> and using <font color="#c75c5c">' . getBrowser() . '</font></font></h3>
    <h3><font color="#7e7e7e">You are located in <font color="#c75c5c">' . $city . '</font> and your ISP is <font color="#c75c5c">' . $isp . '</font></font></h3>
    <h3><font color="#7e7e7e">Your operating system is <font color="#c75c5c">' . getOS() . '</font> and you are <font color="#c75c5c">' . isUsingTor() . '</font> using Tor.</font></h3>
    <h3><font color="#7e7e7e">Have a great day!</font></h3>
</div>
</body>
</html>';
?>
