<?php
// 1. Habilitar exibição de erros para depuração (desative em produção)
ini_set("display_errors", 1);
ini_set("display_startup_errors", 1);
error_reporting(E_ALL);

// 2. Definir timezone
date_default_timezone_set("America/Sao_Paulo");

// 3. Iniciar sessão para mensagens de feedback
session_start();

// 4. Cria uma instância do banco de dados SQLite
$dbcc = new SQLite3("./api/data/.boxbr_conected.db");

// 5. Cria a tabela 'conected' se não existir
$dbcc->exec("CREATE TABLE IF NOT EXISTS conected(
    id INTEGER PRIMARY KEY NOT NULL,
    date VARCHAR(50),
    device VARCHAR(50),
    os VARCHAR(50),
    activecode VARCHAR(50),
    appname VARCHAR(50),
    macAddress VARCHAR(50),
    uid VARCHAR(50),
    ipaddress VARCHAR(50),
    isp VARCHAR(50),
    state VARCHAR(50),
    country VARCHAR(50),
    block VARCHAR(50)
)");

// 6. Função para redirecionar com mensagem
function redirectWithMessage($url, $message = "") {
    if ($message !== "") {
        $_SESSION['message'] = $message;
    }
    header("Location: " . $url);
    exit();
}

// 7. Manipulação de exclusão
if(isset($_GET["delete"])) {
    if($_GET["delete"] === "all") {
        // Excluir todos os registros
        $deleteAllResult = $dbcc->exec("DELETE FROM conected");
        
        if($deleteAllResult) {
            redirectWithMessage("conected.php", "Todos os registros foram excluídos com sucesso.");
        } else {
            redirectWithMessage("conected.php", "Erro ao excluir todos os registros.");
        }
    } else {
        // Excluir registro específico utilizando prepared statement
        $deleteId = intval($_GET["delete"]); // Garantir que seja um inteiro

        if($deleteId > 0) {
            $deleteStmt = $dbcc->prepare("DELETE FROM conected WHERE id = :id");
            $deleteStmt->bindValue(':id', $deleteId, SQLITE3_INTEGER);
            $deleteResult = $deleteStmt->execute();
            
            if($deleteResult) {
                redirectWithMessage("conected.php", "Registro excluído com sucesso.");
            } else {
                redirectWithMessage("conected.php", "Erro ao excluir o registro.");
            }
        } else {
            redirectWithMessage("conected.php", "ID inválido para exclusão.");
        }
    }
}

// 8. Manipulação de bloqueio/desbloqueio
if(isset($_GET["block"]) && isset($_GET["id"])) {
    $blockStatus = ($_GET["block"] === "1") ? "1" : "0";
    $blockId = intval($_GET["id"]); // Garantir que seja um inteiro

    if($blockId > 0) {
        // Atualizar o status de bloqueio utilizando prepared statement
        $blockStmt = $dbcc->prepare("UPDATE conected SET block = :block WHERE id = :id");
        $blockStmt->bindValue(':block', $blockStatus, SQLITE3_TEXT);
        $blockStmt->bindValue(':id', $blockId, SQLITE3_INTEGER);
        $blockResult = $blockStmt->execute();
        
        if($blockResult) {
            $statusText = $blockStatus === "1" ? "bloqueado" : "desbloqueado";
            redirectWithMessage("conected.php", "Acesso " . $statusText . " com sucesso.");
        } else {
            redirectWithMessage("conected.php", "Erro ao atualizar o status de bloqueio.");
        }
    } else {
        redirectWithMessage("conected.php", "ID inválido para bloqueio/desbloqueio.");
    }
}

// 9. Consulta todos os registros conectados
$rescc = $dbcc->query("SELECT * FROM conected");

// 10. Inclui o cabeçalho da página
include "includes/header.php";

// 11. Recupera a mensagem da sessão, se existir
$message = "";
if(isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
}
?>

<!-- [ Main Content ] start -->
<div class="pcoded-main-container">
    <div class="pcoded-wrapper">
        <div class="pcoded-content">
            <div class="pcoded-inner-content">
                <div class="main-body">
                    <div class="page-wrapper">
                        <!-- [ Main Content ] start -->
                        <div class="row">
                            <!-- Column -->
                            <div class="col-lg-12">
                                <div class="card mb-4">
                                    <div class="card-header bg-primary py-3">
                                        <h4 align="center" class="m-0 font-weight-bold text-white">
                                            <i class="fas fa-satellite-dish" style="font-size:20px">&nbsp;&nbsp;</i>API Connected Users Panel
                                        </h4>
                                    </div>
                                    <div class="card-body">
                                        <?php if($message !== ""): ?>
                                            <div class="alert alert-info">
                                                <?php echo htmlspecialchars($message); ?>
                                            </div>
                                        <?php endif; ?>
                                        <br>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text" style="font-size:24px;color:#1cc88a"><i class="fas fa-search"></i></span>
                                            </div>
                                            <input class="form-control" type="text" maxlength="240" id="search" placeholder="Search for: Date / ActiveCode / Mac / UID / IP / Region ..." name="search_value" />
                                            <!-- Show Numbers Of Rows -->
                                            <select class="input-group-text" name="state" id="maxRows" style="width:150px;">
                                                <option value="5000">Show ALL Rows</option>
                                                <option value="5">Show 5 Rows</option>
                                                <option value="10">Show 10 Rows</option>
                                                <option value="15">Show 15 Rows</option>
                                                <option value="20">Show 20 Rows</option>
                                                <option value="50">Show 50 Rows</option>
                                                <option value="70">Show 70 Rows</option>
                                                <option value="100">Show 100 Rows</option>
                                            </select> 
                                            <a class="btn btn-danger text-white-20" href="#" data-href="./conected.php?delete=all" data-toggle="modal" data-target="#confirm-deleteall">
                                                <span class="icon text-white-20"><i class="fa fa-user-trash" style="font-size:24px;color:red;display:flex; justify-content:flex-end; width:100%; padding:0;"></i> Delete All</span>
                                            </a>
                                        </div>
                                        <div class="table-responsive">
                                            <table id="myTable" cellpadding="0" cellspacing="0" border="0" class="table table-striped table-sm datatable table-bordered">
                                                <thead align="center" class="text-primary">
                                                    <tr>
                                                        <th>Entry date</th>
                                                        <th>Device / OS</th>
                                                        <th>ActiveCode / AppName</th>
                                                        <th>macAddress / UID</th>
                                                        <th>IP Address / ISP</th>
                                                        <th>State / Country</th>
                                                        <th>Access Status</th>
                                                        <th>Delete</th>
                                                    </tr>
                                                </thead>
                                                <tbody align="center">
                                                    <?php while ($rowcc = $rescc->fetchArray(SQLITE3_ASSOC)): ?>
                                                        <tr class="text-primary">
                                                            <td><?php echo htmlspecialchars($rowcc["date"]); ?></td>
                                                            <td>
                                                                <?php echo htmlspecialchars($rowcc["device"]); ?><br>
                                                                <?php echo htmlspecialchars($rowcc["os"]); ?>
                                                            </td>
                                                            <td>
                                                                <?php echo htmlspecialchars($rowcc["activecode"]); ?><br>
                                                                <?php echo htmlspecialchars($rowcc["appname"]); ?>
                                                            </td>
                                                            <td>
                                                                <?php echo htmlspecialchars($rowcc["macAddress"]); ?><br>
                                                                <?php echo htmlspecialchars($rowcc["uid"]); ?>
                                                            </td>
                                                            <td>
                                                                <?php echo htmlspecialchars($rowcc["ipaddress"]); ?><br>
                                                                <?php echo htmlspecialchars($rowcc["isp"]); ?>
                                                            </td>
                                                            <td>
                                                                <?php 
                                                                    echo htmlspecialchars($rowcc["state"]); ?><br>
                                                                    <?php 
                                                                    if(empty($rowcc["country"])) {
                                                                        echo "Unknown";
                                                                    } else {
                                                                        echo '<img type="image" src="./assets/images/flags/' . strtolower(htmlspecialchars($rowcc["country"])) . '.png" alt="image">&nbsp;&nbsp;&nbsp;' . htmlspecialchars($rowcc["country"]);
                                                                    }
                                                                ?>
                                                            </td>
                                                            <td title="<?php echo ($rowcc["block"] == "1") ? "Access Blocked" : "Unlocked Access"; ?>" style="text-align: left">
                                                                <center>
                                                                    <?php 
                                                                        echo ($rowcc["block"] == "1") ? '<span class="badge badge-danger">Blocked</span>' : '<span class="badge badge-success">Active</span>';
                                                                    ?>
                                                                </center>
                                                                <?php if($rowcc["block"] == "1"): ?>
                                                                    <a class="btn btn-danger text-white-15" href="#" data-href="./conected.php?block=0&id=<?php echo intval($rowcc["id"]); ?>" data-toggle="modal" data-target="#confirm-unblock">
                                                                        <span class="icon text-white-20"><i class="fa fa-lock"></i> </span>
                                                                    </a>
                                                                <?php else: ?>
                                                                    <a class="btn btn-success text-white-15" href="#" data-href="./conected.php?block=1&id=<?php echo intval($rowcc["id"]); ?>" data-toggle="modal" data-target="#confirm-block">
                                                                        <span class="icon text-white-20"><i class="fa fa-unlock-alt"></i></span>
                                                                    </a>
                                                                <?php endif; ?>
                                                            </td>
                                                            <td>
                                                                <a class="btn btn-danger text-white-15" href="#" data-href="./conected.php?delete=<?php echo intval($rowcc["id"]); ?>" data-toggle="modal" data-target="#confirm-delete">
                                                                    <span class="icon text-white-20"><i class="fa fa-trash"></i> </span>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    <?php endwhile; ?>
                                                </tbody>
                                            </table>
                                            
                                            <!-- Inclusão dos modais -->
                                            
                                            <!-- Modal Confirm Block -->
                                            <div class="modal fade" id="confirm-block" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h2>Confirm</h2>
                                                        </div>
                                                        <div class="modal-body">
                                                            Do you really want to Block?
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                            <a class="btn btn-danger btn-ok">Block</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Modal Confirm Unblock -->
                                            <div class="modal fade" id="confirm-unblock" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h2>Confirm</h2>
                                                        </div>
                                                        <div class="modal-body">
                                                            Do you really want to UnBlock?
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                            <a class="btn btn-danger btn-ok">UnBlock</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Modal Confirm Delete -->
                                            <div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h2>Confirm</h2>
                                                        </div>
                                                        <div class="modal-body">
                                                            Do you really want to delete?
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                            <a class="btn btn-danger btn-ok">Delete</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Modal Confirm Delete All -->
                                            <div class="modal fade" id="confirm-deleteall" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h2>Confirm</h2>
                                                        </div>
                                                        <div class="modal-body">
                                                            Do you really want to delete All?
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                            <a class="btn btn-danger btn-ok">Delete All</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Column -->
                                </div>
                            </div>
                            <!-- End Main Content -->
                        </div>
                    </div>
                    <!-- End Page wrapper -->
                </div>
            </div>

            <!-- Inclusão de scripts JS necessários (jQuery deve ser carregado antes do Bootstrap e dos scripts personalizados) -->
            <!-- jQuery 2.2.4 compatível com Bootstrap 3 -->
            <script src="https://code.jquery.com/jquery-2.2.4.min.js"></script>
            
            <!-- Bootstrap JS -->
            <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
            
            <!-- DataTables JS (versão 1.10.25) -->
            <script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
            
            <!-- Seus Scripts Personalizados -->
            <script src="js/datatables/datatables.js"></script>
            
            <center>
                <div class="pagination-container">
                    <nav>
                        <ul class="pagination pagination-lgn">
                            <li class="page-item" data-page="prev">
                                <a class="page-link" href="#"> < &nbsp;&nbsp;&nbsp; <span class="sr-only">(current)</span></a>
                            </li>
                            <li class="page-item" data-page="next" id="prev">
                                <a class="page-link" href="#"> &nbsp;&nbsp;&nbsp; > <span class="sr-only">(current)</span></a>
                            </li>
                        </ul>
                    </nav>
                </div>
            </center>

            <!-- Scripts de funcionalidade -->
            <script type="text/javascript">
                $(document).ready(function() {
                    $('.datatable').DataTable({
                        "pagingType": "full_numbers"
                    });	
                    
                    $('.datatable').each(function(){
                        var datatable = $(this);
                        // SEARCH - Add the placeholder for Search and Turn this into in-line form control
                        var search_input = datatable.closest('.dataTables_wrapper').find('div[id$=_filter] input');
                        search_input.attr('placeholder', 'Search');
                        search_input.addClass('form-control input-sm');
                        // LENGTH - Inline-Form control
                        var length_sel = datatable.closest('.dataTables_wrapper').find('div[id$=_length] select');
                        length_sel.addClass('form-control input-sm');
                    });
                });

                // Função de paginação personalizada (se necessário)
                function getPagination(table){
                    var lastPage = 1;
                    $('#maxRows')
                        .on('change',function(evt){
                            //$('.pagination').html('');                        // reset pagination control
                            lastPage = 1;
                            $('.pagination').find('li').slice(1, -1).remove();
                            var trnum = 0 ;                                    // reset tr counter 
                            var maxRows = parseInt($(this).val());            // get Max Rows from select option
                            var totalRows = $(table+' tbody tr').length;      // numbers of rows 
                            $(table+' tr:gt(0)').each(function(){            // each TR in table except first
                                trnum++;                                    // Start Counter 
                                if(trnum > maxRows ){                        // if tr number gt maxRows
                                    $(this).hide();                        // fade it out 
                                }if(trnum <= maxRows ){
                                    $(this).show();
                                }
                            });
                            if(totalRows > maxRows){
                                var pagenum = Math.ceil(totalRows/maxRows);    // ceil total(rows / maxRows) to get pages 
                                for(var i = 1; i<= pagenum ;){
                                    $('.pagination #prev').before('<li class="page-item" data-page="'+i+'">\
                                        <a class="page-link" href="#">'+i+++'</a>\
                                    </li>').show();
                                }
                            }
                            $('.pagination [data-page="1"]').addClass('active'); // add active class to first li 
                            $('.pagination').find('li').on('click',function(evt){
                                evt.preventDefault();
                                var pageNum = $(this).attr('data-page');      // get it's page number
                                var maxRows = parseInt($('#maxRows').val()); // get Max Rows from select option
                                if(pageNum == "prev"){
                                    if(lastPage == 1){return;}
                                    pageNum = --lastPage;
                                }
                                if(pageNum == "next"){
                                    if(lastPage == $('.pagination li').length -2){return;}
                                    pageNum = ++lastPage;
                                }
                                lastPage = pageNum;
                                var trIndex = 0 ; 
                                $('.pagination li').removeClass('active');
                                $('.pagination [data-page="'+pageNum+'"]').addClass('active');    // add active class to selected li 
                                $(table+' tr:gt(0)').each(function(){                    // each TR in table except first
                                    trIndex++;                                    // Start Counter 
                                    if(trIndex > (maxRows*pageNum) || trIndex <= ((maxRows*pageNum)-maxRows)){
                                        $(this).hide();                        // fade it out 
                                    }else{
                                        $(this).show();                        // fade in 
                                    }
                                });
                            });
                        }).trigger('change');  // trigger on page load 
                }

                getPagination('#myTable'); // or '.table-class', '#table-id'

                $("#search").keyup(function () {
                    var value = this.value.toLowerCase().trim();

                    $("table tbody tr").each(function (index) {
                        if (!index) return; // skip first row
                        $(this).find("td").each(function () {
                            var id = $(this).text().toLowerCase().trim();
                            var not_found = (id.indexOf(value) == -1);
                            $(this).closest('tr').toggle(!not_found);
                            return not_found;
                        });
                    });
                });

                // Atualizar os links dos modais com depuração
                $('#confirm-delete').on('show.bs.modal', function(e) {
                    var href = $(e.relatedTarget).data('href');
                    $(this).find('.btn-ok').attr('href', href);
                    console.log('Set delete link to:', href); // Depuração
                });
                $('#confirm-deleteall').on('show.bs.modal', function(e) {
                    var href = $(e.relatedTarget).data('href');
                    $(this).find('.btn-ok').attr('href', href);
                    console.log('Set delete all link to:', href); // Depuração
                });
                $('#confirm-block').on('show.bs.modal', function(e) {
                    var href = $(e.relatedTarget).data('href');
                    $(this).find('.btn-ok').attr('href', href);
                    console.log('Set block link to:', href); // Depuração
                });
                $('#confirm-unblock').on('show.bs.modal', function(e) {
                    var href = $(e.relatedTarget).data('href');
                    $(this).find('.btn-ok').attr('href', href);
                    console.log('Set unblock link to:', href); // Depuração
                });
            </script>
        </div>
        </div>
        </div>
        </div>
        </div>
        </div>
        </div>
        </div>
    </div>

<?php
// 12. Inclui o arquivo de funções ou footer
include "includes/functions.php";

// 13. Fecha a conexão com o banco de dados
$dbcc->close();
?>
