<?php
// Conexão com o banco de dados SQLite
$db = new SQLite3("./api/data/.boxbr_info.db");

// Criar a tabela 'act' se ela não existir
$db->exec("CREATE TABLE IF NOT EXISTS act(
    id INTEGER PRIMARY KEY NOT NULL,
    title VARCHAR(50),
    activecode VARCHAR(50),
    macAddress VARCHAR(50),
    uid VARCHAR(50),
    username VARCHAR(50),
    password VARCHAR(50),
    url VARCHAR(50),
    apptype VARCHAR(50),
    appname VARCHAR(50),
    status VARCHAR(50)
)");

// Função para deletar o registro
function deleteRecord($db, $id) {
    $stmt = $db->prepare("DELETE FROM act WHERE id = :id");
    $stmt->bindValue(':id', intval($id), SQLITE3_INTEGER);
    return $stmt->execute();
}

// Verificar se o parâmetro 'delete' está presente na URL
if (isset($_GET["delete"])) {
    if (deleteRecord($db, $_GET["delete"])) {
        header("Location: act.php");
        exit();
    } else {
        echo "Erro ao deletar o registro.";
    }
}

// Recuperar todos os registros da tabela 'act'
$res = $db->query("SELECT * FROM act");

include "includes/header.php";
?>

<div class="pcoded-main-container">
    <div class="pcoded-wrapper">
        <div class="pcoded-content">
            <div class="pcoded-inner-content">
                <div class="main-body">
                    <div class="page-wrapper">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card mb-4">
                                    <div class="card-header bg-primary py-3">
                                        <h4 class="m-0 font-weight-bold text-white">
                                            <i class="fas fa-server" style="font-size:20px">&nbsp;&nbsp;</i> Gerenciamento de Códigos Ativos
                                        </h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="input-group mb-3">
                                            <div class="input-group-prepend">
                                                <a href="./add_act.php">
                                                    <button class="btn btn-primary btn-icon-split">
                                                        <span class="icon text-white-50"><i class="fa fa-plus"></i></span>
                                                        &nbsp;&nbsp;<span class="text">Adicionar Código</span>
                                                    </button>
                                                </a>
                                                <span class="input-group-text" style="font-size:24px;color:#1cc88a">
                                                    <i class="fas fa-search"></i>
                                                </span>
                                            </div>
                                            <input class="form-control" type="text" maxlength="240" id="search" placeholder="Buscar: Código / Nome / App / DNS / Usuário / Senha" name="search_value" />
                                            <select class="input-group-text" name="state" id="maxRows" style="width:150px;">
                                                <option value="5000">Mostrar TODAS as Linhas</option>
                                                <option value="5">Mostrar 5 Linhas</option>
                                                <option value="10">Mostrar 10 Linhas</option>
                                                <option value="15">Mostrar 15 Linhas</option>
                                                <option value="20">Mostrar 20 Linhas</option>
                                                <option value="50">Mostrar 50 Linhas</option>
                                                <option value="70">Mostrar 70 Linhas</option>
                                                <option value="100">Mostrar 100 Linhas</option>
                                            </select>
                                        </div>
                                        <div class="table-responsive">
                                            <table class="table table-striped table-sm">
                                                <thead class="text-primary">
                                                    <tr>
                                                        <th>Serviço / DNS</th>
                                                        <th>Usuário / Senha</th>
                                                        <th>Código Ativo</th>
                                                        <th>MacAddress / UID</th>
                                                        <th>Nome do App / Tipo</th>
                                                        <th>Editar</th>
                                                        <th>Deletar</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php while ($row = $res->fetchArray()) { ?>
                                                        <tr>
                                                            <td><?php echo $row["title"] . "<br>" . $row["url"]; ?></td>
                                                            <td><?php echo "Usuário: " . $row["username"] . "<br>Senha: " . $row["password"]; ?></td>
                                                            <td><?php echo $row["activecode"]; ?></td>
                                                            <td><?php echo isset($row["macAddress"]) ? "MAC: " . $row["macAddress"] : ""; ?><br><?php echo isset($row["uid"]) ? "UID: " . $row["uid"] : ""; ?></td>
                                                            <td><?php echo $row["appname"]; ?></td>
                                                            <td>
                                                                <a class="btn btn-success text-white-20" href="./edit_act.php?update=<?php echo $row["id"]; ?>">
                                                                    <i class="fa fa-edit"></i>
                                                                </a>
                                                            </td>
                                                            <td>
                                                                <form action="act.php" method="get" style="display:inline;">
                                                                    <input type="hidden" name="delete" value="<?php echo $row["id"]; ?>">
                                                                    <button type="submit" class="btn btn-danger text-white-20">
                                                                        <i class="fa fa-trash"></i>
                                                                    </button>
                                                                </form>
                                                            </td>
                                                        </tr>
                                                    <?php } ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- [ Main Content ] end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>