<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Configurações de exibição de erros
ini_set("display_errors", 0);
ini_set("display_startup_errors", 0);
error_reporting(E_ALL);

// Cria uma instância do banco de dados SQLite
$db = new SQLite3("./api/data/.boxbr_info.db");

// Recupera o ID a ser atualizado a partir do parâmetro GET 'update'
$update_id = isset($_GET["update"]) ? intval($_GET["update"]) : 0;

// Consulta o banco de dados para obter os dados do ActiveCode a ser editado usando prepared statements
$stmt = $db->prepare("SELECT * FROM act WHERE id = :id");
$stmt->bindValue(':id', $update_id, SQLITE3_INTEGER);
$res = $stmt->execute();
$row = $res->fetchArray(SQLITE3_ASSOC);

if (!$row) {
    // Se não encontrar o registro, redireciona para a página de listagem
    header("Location: act.php");
    exit();
}

// Variáveis para selecionar as opções corretas no formulário
$apptype = $row["apptype"];
$status = $row["status"];

// Processa o formulário de edição quando submetido
if (isset($_POST["submit"])) {
    // Recupera os dados do formulário com validação básica
    $id = intval($_POST["id"]);
    $title = trim($_POST["title"]);
    $activecode = trim($_POST["activecode"]);
    $macAddress = trim($_POST["macAddress"]); // Removido strtoupper
    $uid = trim($_POST["uid"]);
    $username = trim($_POST["username"]);
    $password = trim($_POST["password"]);
    $url = trim($_POST["url"]);
    $apptype = intval($_POST["apptype"]);
    $appname = trim($_POST["appname"]);
    $status = intval($_POST["status"]);

    // Prepara a consulta de atualização usando prepared statements
    $updateStmt = $db->prepare("UPDATE act SET 
        title = :title, 
        activecode = :activecode, 
        macAddress = :macAddress, 
        uid = :uid, 
        username = :username, 
        password = :password, 
        url = :url, 
        apptype = :apptype, 
        appname = :appname, 
        status = :status 
        WHERE id = :id");

    // Vincula os valores aos parâmetros
    $updateStmt->bindValue(':title', $title, SQLITE3_TEXT);
    $updateStmt->bindValue(':activecode', $activecode, SQLITE3_TEXT);
    $updateStmt->bindValue(':macAddress', $macAddress, SQLITE3_TEXT);
    $updateStmt->bindValue(':uid', $uid, SQLITE3_TEXT);
    $updateStmt->bindValue(':username', $username, SQLITE3_TEXT);
    $updateStmt->bindValue(':password', $password, SQLITE3_TEXT);
    $updateStmt->bindValue(':url', $url, SQLITE3_TEXT);
    $updateStmt->bindValue(':apptype', $apptype, SQLITE3_INTEGER);
    $updateStmt->bindValue(':appname', $appname, SQLITE3_TEXT);
    $updateStmt->bindValue(':status', $status, SQLITE3_INTEGER);
    $updateStmt->bindValue(':id', $id, SQLITE3_INTEGER);

    // Executa a consulta de atualização
    $updateResult = $updateStmt->execute();

    if ($updateResult) {
        // Redireciona para a página de listagem após sucesso
        header("Location: act.php");
        exit();
    } else {
        echo "Erro ao atualizar os dados no banco.";
    }
}

// Inclui o cabeçalho da página
include "includes/header.php";
?>

<!-- [ Main Content ] start -->
<div class="pcoded-main-container">
    <div class="pcoded-wrapper">
        <div class="pcoded-content">
            <div class="pcoded-inner-content">
                <div class="main-body">
                    <div class="page-wrapper">
                        <!-- [ Main Content ] start -->
                        <div class="row">
                            <!-- Column -->
                            <div class="col-lg-12">
                                <div class="card mb-4">
                                    <div class="card-header bg-primary py-3">
                                        <h4 align="center" class="m-0 font-weight-bold text-white">
                                            <i class="fas fa-code" style="font-size:20px">&nbsp;&nbsp;</i>Editar ActiveCode: [ <?php echo htmlspecialchars($row["activecode"]); ?> ]
                                        </h4>
                                    </div>
                                    <div class="card-body">
                                        <form method="post">
                                            <!-- Campo Oculto para ID -->
                                            <input type="hidden" name="id" value="<?php echo intval($row["id"]); ?>">

                                            <!-- Campo Oculto para UID (se necessário) -->
                                            <input type="hidden" name="uid" value="<?php echo htmlspecialchars($row["uid"]); ?>">

                                            <!-- Campo Oculto para ActiveCode -->
                                            <input type="hidden" name="activecode" id="activecode" value="<?php echo htmlspecialchars($row["activecode"]); ?>" required>

                                            <!-- Campo Service Name -->
                                            <div class="form-group">
                                                <label for="title"><strong>Service Name</strong></label>
                                                <input type="text" id="title" name="title" class="form-control text-primary" value="<?php echo htmlspecialchars($row["title"]); ?>" required>
                                            </div>

                                            <!-- Campo Mac Address -->
                                            <div class="form-group">
                                                <label for="macAddress"><strong>Mac Address</strong></label>
                                                <input type="text" id="macAddress" name="macAddress" class="form-control text-primary" maxlength="17" value="<?php echo htmlspecialchars($row["macAddress"]); ?>">
                                            </div>

                                            <!-- Novo Campo M3U com Botão de Extração -->
                                            <div class="form-group">
                                                <label for="m3u"><strong>Lista M3U</strong></label>
                                                <div class="input-group">
                                                    <input type="text" id="m3u" name="m3u" class="form-control text-primary" placeholder="Cole o link M3U aqui" value="">
                                                    <button type="button" class="btn btn-secondary" onclick="extractM3U()">
                                                        <i class="fa fa-download"></i> Extrair
                                                    </button>
                                                </div>
                                            </div>

                                            <!-- Campo Username -->
                                            <div class="form-group">
                                                <label for="username"><strong>Username</strong></label>
                                                <input type="text" id="username" name="username" class="form-control text-primary" value="<?php echo htmlspecialchars($row["username"]); ?>" required>
                                            </div>

                                            <!-- Campo Password -->
                                            <div class="form-group">
                                                <label for="password"><strong>Password</strong></label>
                                                <input type="text" id="password" name="password" class="form-control text-primary" value="<?php echo htmlspecialchars($row["password"]); ?>" required>
                                            </div>

                                            <!-- Campo Service DNS -->
                                            <div class="form-group">
                                                <label for="url"><strong>Service DNS</strong></label>
                                                <input type="text" id="url" name="url" class="form-control text-primary" value="<?php echo htmlspecialchars($row["url"]); ?>">
                                            </div>

                                            <!-- Campo App Type -->
                                            <div class="form-group">
                                                <label for="apptype"><strong>App Type</strong></label>
                                                <select class="form-control type" id="apptype" name="apptype">
                                                    <option value="0" <?php echo ($apptype == "0") ? "selected" : ""; ?>>Dual TV/Vod</option>
                                                    <option value="1" <?php echo ($apptype == "1") ? "selected" : ""; ?>>Only TV</option>
                                                    <option value="2" <?php echo ($apptype == "2") ? "selected" : ""; ?>>Only Vod</option>
                                                </select>
                                            </div>

                                            <!-- Campo App Name -->
                                            <div class="form-group">
                                                <label for="appname"><strong>App Name</strong></label>
                                                <input type="text" id="appname" name="appname" class="form-control text-primary" value="<?php echo htmlspecialchars($row["appname"]); ?>">
                                            </div>

                                            <!-- Campo Status -->
                                            <div class="form-group">
                                                <label for="status"><strong>Status</strong></label>
                                                <select class="form-control type" id="status" name="status">
                                                    <option value="1" <?php echo ($status == "1") ? "selected" : ""; ?>>ACTIVE</option>
                                                    <option value="0" <?php echo ($status == "0") ? "selected" : ""; ?>>INACTIVE</option>
                                                </select>
                                            </div>

                                            <!-- Botão de Submissão -->
                                            <div align="center" class="form-group mb-3">
                                                <br>
                                                <button type="submit" name="submit" class="btn btn-danger btn-icon-split">
                                                    <span class="icon text-white-50">
                                                        <i class="fas fa-save"></i>&nbsp;&nbsp;
                                                    </span>
                                                    <span class="text"> Save Settings</span>
                                                </button>
                                            </div>
                                        </form>

                                        <!-- Mensagem de Sucesso Opcional (comentada para não exibir) -->
                                        <!--
                                        <div id="successMessage" style="display:none; color: green; text-align: center; margin-top: 10px;">
                                            Dados extraídos com sucesso!
                                        </div>
                                        -->
                                    </div>
                                </div>
                            </div>
                            <!-- Column -->
                        </div>
                    </div>
                </div>
                <!-- End Main Content -->
            </div>
        </div>
        <!-- End Page wrapper -->
    </div>
</div>

<script src="http://code.jquery.com/jquery-latest.js"></script>
<script type="text/javascript">
function extractM3U() {
    const m3uLink = document.getElementById("m3u").value.trim();

    if (m3uLink === "") {
        alert("Por favor, insira um link M3U válido.");
        return;
    }

    try {
        // Cria um objeto URL para facilitar a extração dos parâmetros
        const url = new URL(m3uLink);

        // Extrai o Service DNS (incluindo o protocolo https://)
        const serviceDNS = url.origin; // Isso inclui o protocolo (http:// ou https://) e o hostname
        document.getElementById("url").value = serviceDNS;

        // Extrai os parâmetros 'username' e 'password' da query string
        const username = url.searchParams.get("username") || "";
        const password = url.searchParams.get("password") || "";

        if (username && password) {
            document.getElementById("username").value = username;
            document.getElementById("password").value = password;
        } else {
            // Se os parâmetros não estiverem na query string, tentar extrair de outras formas
            const params = new URLSearchParams(url.search);
            document.getElementById("username").value = params.get('username') || "";
            document.getElementById("password").value = params.get('password') || "";
        }

        // Removido o alerta "Dados extraídos com sucesso!"
        // Se desejar adicionar feedback visual, descomente as linhas abaixo
        /*
        const successMsg = document.getElementById("successMessage");
        successMsg.style.display = "block";
        setTimeout(() => {
            successMsg.style.display = "none";
        }, 3000);
        */
    } catch (error) {
        console.error(error);
        alert("O link M3U fornecido não é válido.");
    }
}

// Função para formatar o MAC Address conforme digitado
document.getElementById("macAddress").addEventListener('keyup', function() { 
    var mac = document.getElementById('macAddress').value;
    var macs = mac.split(':').join('');
    macs = chunk(macs, 2).join(':');
    document.getElementById('macAddress').value = macs.toString();
});

// Função auxiliar para dividir a string em chunks de n caracteres
function chunk(str, n) {
    var ret = [];
    for (var i = 0; i < str.length; i += n) {
        ret.push(str.substr(i, n));
    }
    return ret;
}

// Função getact (preservada, mas parece não estar sendo usada)
function getact() {
    var alfabeto = "ABCDEFGHIJKLMNOPQRSTUVXWYZ";
    var letras = [];
    for (var i = 0; i < 10; ++i)
        letras[i] = alfabeto.charAt(Math.floor(Math.random() * 25));

    var numeros = [];
    for (var i = 0; i < 10; ++i) {
        var sorteio = Math.floor(Math.random() * 9);
        if (sorteio == 0)
            sorteio = 1;
        numeros[i] = sorteio;
    }

    var senha = letras.join('') + numeros.join('');
    document.getElementById('act').value = letras.join('');
}
</script>

<?php
// Inclui o arquivo de funções ou footer
include "includes/functions.php";

// Fecha a conexão com o banco de dados
$db->close();
?>
