<?php
// Conectar ao banco de dados
$db = new SQLite3("./api/data/.boxbr_info.db");

// Criar a tabela se não existir
$db->exec("CREATE TABLE IF NOT EXISTS dns(id INTEGER PRIMARY KEY NOT NULL, title VARCHAR(50), url VARCHAR(50))");

// Deletar o registro se o parâmetro 'delete' estiver presente na URL
if (isset($_POST["delete_id"])) {
    $id = intval($_POST["delete_id"]); // Sanitizar o ID
    $stmt = $db->prepare("DELETE FROM dns WHERE id = :id");
    $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
    $stmt->execute();
    header("Location: dns.php");
    exit();
}

// Recuperar todos os registros da tabela 'dns'
$res = $db->query("SELECT * FROM dns");

include "includes/header.php";
?>

<!-- [ Main Content ] start -->
<div class="pcoded-main-container">
    <div class="pcoded-wrapper">
        <div class="pcoded-content">
            <div class="pcoded-inner-content">
                <div class="main-body">
                    <div class="page-wrapper">
                        <div class="row">
                            <!-- Column -->
                            <div class="col-lg-12">
                                <div class="card mb-4">
                                    <div class="card-header bg-primary py-3">
                                        <h4 align="center" class="m-0 font-weight-bold text-white">
                                            <i class="fas fa-server" style="font-size:20px">&nbsp;&nbsp;</i> DNS Management
                                        </h4>
                                    </div>
                                    <div class="card-body">
                                        <br>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <a href="./add_dns.php">
                                                    <button class="btn btn-success btn-icon-split" name="submit" type="submit">
                                                        <span class="icon text-white-50"><i class="fa fa-plus"></i></span>&nbsp;&nbsp;<span class="text"> Add A DNS</span>
                                                    </button>
                                                </a>
                                                <span class="input-group-text" style="font-size:24px;color:#1cc88a">
                                                    <i class="fas fa-search"></i>
                                                </span>
                                            </div>
                                            <input class="form-control" type="text" maxlength="240" id="search" placeholder="Search for: Name / DNS ..." name="search_value" />
                                            <!-- Show Numbers Of Rows -->
                                            <select class="input-group-text" name="state" id="maxRows" style="width:150px;">
                                                <option value="5000">Show ALL Rows</option>
                                                <option value="5">Show 5 Rows</option>
                                                <option value="10">Show 10 Rows</option>
                                                <option value="15">Show 15 Rows</option>
                                                <option value="20">Show 20 Rows</option>
                                                <option value="50">Show 50 Rows</option>
                                                <option value="70">Show 70 Rows</option>
                                                <option value="100">Show 100 Rows</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="table-responsive">
                                        <table id="myTable" cellpadding="0" cellspacing="0" border="0" class="table stable-striped table-sm datatable stable-bordered">
                                            <thead align="center" class="text-primary">
                                                <tr>
                                                    <th><strong>Service Name</strong></th>
                                                    <th><strong>Service DNS</strong></th>
                                                    <th><strong>Edit</strong></th>
                                                    <th><strong>Delete</strong></th>
                                                </tr>
                                            </thead>
                                            <?php
                                            while ($row = $res->fetchArray()) {
                                                echo "<tbody align=\"center\">";
                                                echo "<tr class=\"text-primary\">";
                                                echo "<td>" . htmlspecialchars($row["title"]) . "</td>";
                                                echo "<td>" . htmlspecialchars($row["url"]) . "</td>";
                                                echo "<td>";
                                                echo "<a class=\"btn btn-success text-white-15\" href=\"./edit_dns.php?update=" . $row["id"] . "\">";
                                                echo "<span style=\"font-size:15px;\" class=\"icon text-white-10\"><i class=\"fa fa-edit\"></i> </span>";
                                                echo "</a>";
                                                echo "</td>";
                                                echo "<td>";
                                                echo "<form action=\"dns.php\" method=\"POST\" style=\"display:inline;\">";
                                                echo "<input type=\"hidden\" name=\"delete_id\" value=\"" . $row["id"] . "\" />";
                                                echo "<button type=\"submit\" class=\"btn btn-danger text-white-15\" onclick=\"return confirm('Do you really want to delete?');\">";
                                                echo "<span style=\"font-size:15px;\" class=\"icon text-white-10\"><i class=\"fa fa-trash\"></i> </span>";
                                                echo "</button>";
                                                echo "</form>";
                                                echo "</td>";
                                                echo "</tr>";
                                                echo "</tbody>";
                                            }
                                            ?>
                                        </table>
                                        <script src="//cdnjs.cloudflare.com/ajax/libs/datatables/1.9.4/jquery.dataTables.min.js"></script>
                                        <script src="js/datatables/datatables.js"></script>
                                        <script type="text/javascript">
                                            $(document).ready(function() {
                                                $('.datatable').dataTable({
                                                    "sPaginationType": "bs_four_button"
                                                });
                                                $('.datatable').each(function() {
                                                    var datatable = $(this);
                                                    // SEARCH - Add the placeholder for Search and Turn this into in-line form control
                                                    var search_input = datatable.closest('.dataTables_wrapper').find('div[id$=_filter] input');
                                                    search_input.attr('placeholder', 'Search');
                                                    search_input.addClass('form-control input-sm');
                                                    // LENGTH - Inline-Form control
                                                    var length_sel = datatable.closest('.dataTables_wrapper').find('div[id$=_length] select');
                                                    length_sel.addClass('form-control input-sm');
                                                });
                                            });
                                        </script>
                                        <script src="http://netdna.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
                                        <center>
                                            <div class="pagination-container">
                                                <nav>
                                                    <ul class="pagination pagination-lgn">
                                                        <li class="page-item" data-page="prev">
                                                            <a class="page-link" href="#"> < &nbsp;&nbsp;&nbsp; <span class="sr-only">(current)</span></a>
                                                        </li>
                                                        <li class="page-item" data-page="next" id="prev">
                                                            <a class="page-link" href="#"> &nbsp;&nbsp;&nbsp; > <span class="sr-only">(current)</span></a>
                                                        </li>
                                                    </ul>
                                                </nav>
                                            </div>
                                        </center>
                                        <script type="text/javascript">
                                            getPagination('#table-id');
                                            //getPagination('.table-class');
                                            getPagination('table');
                                        </script>
                                        <script>
                                            $("#search").keyup(function () {
                                                var value = this.value.toLowerCase().trim();
                                                $("table tr").each(function (index) {
                                                    if (!index) return;
                                                    $(this).find("td").each(function () {
                                                        var id = $(this).text().toLowerCase().trim();
                                                        var not_found = (id.indexOf(value) == -1);
                                                        $(this).closest('tr').toggle(!not_found);
                                                        return not_found;
                                                    });
                                                });
                                            });
                                        </script>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- [ Main Content ] end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php require "includes/functions.php"; ?>