<?php
date_default_timezone_set("America/Sao_Paulo");

// Função para obter o endereço IP do usuário
function getIpAddress() {
    $ip = "undefined";
    if (isset($_SERVER)) {
        $ip = $_SERVER["REMOTE_ADDR"];
        if (isset($_SERVER["HTTP_X_FORWARDED_FOR"])) {
            $ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
        } elseif (isset($_SERVER["HTTP_CLIENT_IP"])) {
            $ip = $_SERVER["HTTP_CLIENT_IP"];
        }
    } else {
        $ip = getenv("REMOTE_ADDR");
        if (getenv("HTTP_X_FORWARDED_FOR")) {
            $ip = getenv("HTTP_X_FORWARDED_FOR");
        } elseif (getenv("HTTP_CLIENT_IP")) {
            $ip = getenv("HTTP_CLIENT_IP");
        }
    }
    return htmlspecialchars($ip, ENT_QUOTES, "UTF-8");
}

// Função para identificar o sistema operacional
function getOperatingSystem() {
    global $user_agent;
    $os = "Unknown";
    $os_patterns = [
        "/windows nt 10/i" => "Windows 10",
        "/windows nt 6.3/i" => "Windows 8.1",
        "/windows nt 6.2/i" => "Windows 8",
        "/windows nt 6.1/i" => "Windows 7",
        "/windows nt 6.0/i" => "Windows Vista",
        "/windows nt 5.2/i" => "Windows Server 2003/XP x64",
        "/windows nt 5.1/i" => "Windows XP",
        "/windows nt 5.0/i" => "Windows 2000",
        "/windows me/i" => "Windows ME",
        "/win98/i" => "Windows 98",
        "/win95/i" => "Windows 95",
        "/win16/i" => "Windows 3.11",
        "/macintosh|mac os x/i" => "Mac OS X",
        "/mac_powerpc/i" => "Mac OS 9",
        "/linux/i" => "Linux",
        "/ubuntu/i" => "Ubuntu",
        "/iphone/i" => "iPhone",
        "/ipod/i" => "iPod",
        "/ipad/i" => "iPad",
        "/android/i" => "Android",
        "/blackberry/i" => "BlackBerry",
        "/webos/i" => "WebOS",
        "/tizen/i" => "Tizen",
        "/smart tv/i" => "Smart TV"
    ];
    foreach ($os_patterns as $pattern => $name) {
        if (preg_match($pattern, $user_agent)) {
            $os = $name;
            break;
        }
    }
    return $os;
}

// Função para identificar o navegador
function getUserBrowser() {
    global $user_agent;
    $browser = "Unknown";
    $browser_patterns = [
        "/msie/i" => "Internet Explorer",
        "/firefox/i" => "Firefox",
        "/safari/i" => "Safari",
        "/chrome/i" => "Chrome",
        "/edge/i" => "Edge",
        "/opera/i" => "Opera",
        "/netscape/i" => "Netscape",
        "/maxthon/i" => "Maxthon",
        "/konqueror/i" => "Konqueror",
        "/SamsungBrowser/i" => "Samsung Browser",
        "/Mobile Safari/i" => "Mobile Browser"
    ];
    foreach ($browser_patterns as $pattern => $name) {
        if (preg_match($pattern, $user_agent)) {
            $browser = $name;
            break;
        }
    }
    return $browser;
}

// Função para identificar o dispositivo
function getDevice() {
    global $user_agent;
    $device = "Unknown";
    $device_patterns = [
        "/okhttp/i" => "ACTIVE DEVICE",
        "/xiaomi/i" => "XIAOMI",
        "/android/i" => "ANDROID",
        "/A96/i" => "TVBOX",
        "/A95/i" => "TVBOX",
        "/TX9/i" => "TVBOX",
        "/TX6/i" => "TVBOX",
        "/TX3/i" => "TVBOX",
        "/TX2/i" => "TVBOX",
        "/MX9/i" => "TVBOX",
        "/MXQ/i" => "TVBOX",
        "/MX10/i" => "TVBOX",
        "/V88/i" => "TVBOX",
        "/Stick/i" => "TVBOX",
        "/MiBox/i" => "TVBOX",
        "/Dolamee/i" => "TVBOX"
    ];
    foreach ($device_patterns as $pattern => $name) {
        if (preg_match($pattern, $user_agent)) {
            $device = $name;
            break;
        }
    }
    return $device;
}

// Coletar dados do usuário
$user_agent = $_SERVER["HTTP_USER_AGENT"];
$date = date("d-m-Y H:i:s");
$ipaddress = getIpAddress();
$device = getDevice();
$os = getOperatingSystem();
$ipl = $ipaddress; // Usando o IP do usuário
$details = json_decode(file_get_contents("https://ipinfo.io/" . $ipl . "/json"));
$country = $details->country;
$state = $details->region;
$city = $details->city;
$isp = $details->org;
$isp = preg_replace("/AS\\d{1,}\\s/", "", $isp);
$loc = $details->loc;

// Coletar parâmetros da URL
$Cactivecode = isset($_GET["activecode"]) ? $_GET["activecode"] : "Hacking Attempt";
$CmacAddress = isset($_GET["macAddress"]) ? urldecode($_GET["macAddress"]) : (isset($_GET["macid"]) ? urldecode($_GET["macid"]) : "Hacking Attempt");
$Cappname = isset($_GET["appname"]) ? $_GET["appname"] : (isset($_GET["number"]) ? "AppDual-" . $_GET["number"] : "Hacking Attempt");
$Cuid = isset($_GET["uid"]) ? $_GET["uid"] : (isset($_GET["macid"]) ? urldecode($_GET["macid"]) : "Hacking Attempt");

// Conectar ao banco de dados SQLite
$dbcc = new SQLite3("./data/.boxbr_conected.db");
$dbcc->exec("CREATE TABLE IF NOT EXISTS conected (
    id INTEGER PRIMARY KEY NOT NULL,
    date VARCHAR(50),
    device VARCHAR(50),
    os VARCHAR(50),
    activecode VARCHAR(50),
    appname VARCHAR(50),
    macAddress VARCHAR(50),
    uid VARCHAR(50),
    ipaddress VARCHAR(50),
    isp VARCHAR(50),
    state VARCHAR(50),
    country VARCHAR(50),
    block VARCHAR(50)
)");

// Inserir dados no banco de dados
$dbcc->exec("INSERT INTO conected (
    date, device, os, activecode, appname, macAddress, uid, ipaddress, isp, state, country
) VALUES (
    '$date', '$device', '$os', '$Cactivecode', '$Cappname', '$CmacAddress', '$Cuid', '$ipaddress', '$isp', '$state', '$country'
)");

// Fechar conexão com o banco de dados
$dbcc->close();

// Retornar resposta em JSON
echo json_encode(["status" => true, "msg" => "reset code"]);
?>
