<?php
// Configurações de exibição de erros
ini_set("display_errors", 0);
ini_set("display_startup_errors", 0);
error_reporting(E_ALL);

// Cria uma instância do banco de dados SQLite
$db = new SQLite3("./api/data/.boxbr_info.db");

// Função para gerar um código ativo aleatório de 6 dígitos
function generateRandomCode() {
    return str_pad(mt_rand(0, 999999), 6, '0', STR_PAD_LEFT);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST["submit"])) {
        // Trata a submissão do formulário para adicionar um registro

        // Gera um código ativo aleatório de 6 dígitos
        $code = generateRandomCode();

        // Consulta o banco de dados para verificar se o código já existe
        $stmt = $db->prepare("SELECT * FROM act WHERE activecode = :activecode");
        $stmt->bindValue(':activecode', $code, SQLITE3_TEXT);
        $res = $stmt->execute();
        $row = $res->fetchArray();

        // Define o código ativo a ser inserido no banco de dados
        if ($row && $row["activecode"] === $code) {
            $actcode = generateRandomCode();
        } else {
            $actcode = $code;
        }

        // Prepara a inserção dos dados no banco de dados usando prepared statements para segurança
        $insertStmt = $db->prepare("INSERT INTO act (title, activecode, macAddress, uid, username, password, url, apptype, appname, status) 
                                    VALUES (:title, :activecode, :macAddress, :uid, :username, :password, :url, :apptype, :appname, :status)");
        $insertStmt->bindValue(':title', $_POST["title"], SQLITE3_TEXT);
        $insertStmt->bindValue(':activecode', $actcode, SQLITE3_TEXT);
        $insertStmt->bindValue(':macAddress', $_POST["macAddress"], SQLITE3_TEXT);
        $insertStmt->bindValue(':uid', $_POST["uid"], SQLITE3_TEXT);
        $insertStmt->bindValue(':username', $_POST["username"], SQLITE3_TEXT);
        $insertStmt->bindValue(':password', $_POST["password"], SQLITE3_TEXT);
        $insertStmt->bindValue(':url', $_POST["url"], SQLITE3_TEXT);
        $insertStmt->bindValue(':apptype', $_POST["apptype"], SQLITE3_INTEGER);
        $insertStmt->bindValue(':appname', $_POST["appname"], SQLITE3_TEXT);
        $insertStmt->bindValue(':status', $_POST["status"], SQLITE3_INTEGER);

        $insertResult = $insertStmt->execute();

        if ($insertResult) {
            // Redireciona para outra página após sucesso
            header("Location: act.php");
            exit();
        } else {
            echo "Erro ao inserir os dados no banco.";
        }
    }
}

// Inclui o cabeçalho da página
include "includes/header.php";

// Conteúdo HTML da página
echo <<<HTML
<!-- [ Main Content ] start -->
<div class="pcoded-main-container">
    <div class="pcoded-wrapper">
        <div class="pcoded-content">
            <div class="pcoded-inner-content">
                <div class="main-body">
                    <div class="page-wrapper">
                        <!-- [ Main Content ] start -->
                        <div class="row">
                            <!-- Column -->
                            <div class="col-lg-12">
                                <div class="card mb-4">
                                    <div class="card-header bg-primary py-3">
                                        <h4 align="center" class="m-0 font-weight-bold text-white">
                                            <i class="fas fa-code" style="font-size:20px">&nbsp;&nbsp;</i>Add A ActiveCode
                                        </h4>
                                    </div>
                                    <div class="card-body">
                                        <form method="post">
                                            <div class="form-group">
                                                <label class="form-label" for="title"><strong>Service Name</strong></label>
                                                <input class="form-control text-primary" id="title" name="title" type="text" required/>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label" for="macAddress"><strong>Mac Address</strong></label>
                                                <input class="form-control text-primary" maxlength="17" id="macAddress" name="macAddress" type="text"/>
                                            </div>
                                            
                                            <!-- Novo Campo M3U com Botão de Extração -->
                                            <div class="form-group">
                                                <label class="form-label" for="m3u"><strong>Lista M3U</strong></label>
                                                <div class="input-group">
                                                    <input type="text" id="m3u" name="m3u" class="form-control text-primary" placeholder="Cole o link M3U aqui" />
                                                    <button type="button" class="btn btn-secondary" onclick="extractM3U()">
                                                        <i class="fa fa-download"></i> Extrair
                                                    </button>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group">
                                                <label class="form-label" for="username"><strong>Username</strong></label>
                                                <input class="form-control text-primary" id="username" name="username" type="text" required/>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label" for="password"><strong>Password</strong></label>
                                                <input class="form-control text-primary" id="password" name="password" type="text" required/>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label" for="url"><strong>Service DNS</strong></label>
                                                <input class="form-control text-primary" id="url" name="url" type="text"/>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label" for="apptype"><strong>App Type</strong></label>
                                                <select class="input-group form-control type" id="apptype" name="apptype">
                                                    <option value="0">Dual TV/Vod</option>
                                                    <option value="1">Only TV</option>
                                                    <option value="2">Only Vod</option>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label" for="appname"><strong>App Name</strong></label>
                                                <input class="form-control text-primary" id="appname" name="appname" type="text"/>
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label" for="status"><strong>Status</strong></label>
                                                <select class="input-group form-control type" id="status" name="status">
                                                    <option value="1">ACTIVE</option>
                                                    <option value="0">INACTIVE</option>
                                                </select>
                                            </div>
                                            <div align="center" class="form-group">
                                                <br>
                                                <button class="btn btn-danger" name="submit" type="submit">
                                                    <span class="icon text-white-50">
                                                        <i class="fa fa-plus"></i>&nbsp;&nbsp;
                                                    </span>
                                                    <span class="text"> Add A Code</span>
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <!-- Column -->
                        </div>
                    </div>
                </div>
                <!-- End Container fluid -->
            </div>
        </div>
        <!-- End Page wrapper -->
    </div>
</div>

<script src="http://code.jquery.com/jquery-latest.js"></script>
<script type="text/javascript">
function extractM3U() {
    const m3uLink = document.getElementById("m3u").value.trim();

    if (m3uLink === "") {
        alert("Por favor, insira um link M3U válido.");
        return;
    }

    try {
        // Cria um objeto URL para facilitar a extração dos parâmetros
        const url = new URL(m3uLink);

        // Extrai o Service DNS (incluindo o protocolo https://)
        const serviceDNS = url.origin; // Isso inclui o protocolo (http:// ou https://) e o hostname
        document.getElementById("url").value = serviceDNS;

        // Extrai os parâmetros 'username' e 'password' da query string
        const username = url.searchParams.get("username") || "";
        const password = url.searchParams.get("password") || "";

        if (username && password) {
            document.getElementById("username").value = username;
            document.getElementById("password").value = password;
        } else {
            // Se os parâmetros não estiverem na query string, tentar extrair de outras formas
            // Por exemplo, se o link for algo como http://serviceDNS/get.php?username=XXX&password=YYY
            const params = new URLSearchParams(url.search);
            document.getElementById("username").value = params.get('username') || "";
            document.getElementById("password").value = params.get('password') || "";
        }

        // Removido o alerta "Dados extraídos com sucesso!"
        // alert("Dados extraídos com sucesso!");
    } catch (error) {
        console.error(error);
        alert("O link M3U fornecido não é válido.");
    }
}

document.getElementById("macAddress").addEventListener('keyup', function() { 
    var mac = document.getElementById('macAddress').value;
    var macs = mac.split(':').join('');
    macs = chunk(macs, 2).join(':');
    document.getElementById('macAddress').value = macs.toString();
});

function chunk(str, n) {
    var ret = [];
    for (var i = 0; i < str.length; i += n) {
        ret.push(str.substr(i, n));
    }
    return ret;
}

function getact() {
    var alfabeto = "ABCDEFGHIJKLMNOPQRSTUVXWYZ";
    var letras = [];
    for (var i = 0; i < 10; ++i)
        letras[i] = alfabeto.charAt(Math.floor(Math.random() * 25));

    var numeros = [];
    for (var i = 0; i < 10; ++i) {
        var sorteio = Math.floor(Math.random() * 9);
        if (sorteio == 0)
            sorteio = 1;
        numeros[i] = sorteio;
    }

    var senha = letras.join('') + numeros.join('');
    document.getElementById('act').value = letras.join('');
}
</script>
HTML;

?>
