/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DedexerTask;
import hu.uw.pallergabor.dedexer.DexInstructionParser;
import java.io.IOException;
import java.util.ArrayList;

public class PackedSwitchTask
extends DedexerTask {
    private long tableLength = 0L;
    private int reg = 0;
    private int low = 0;
    private long[] jumpTable = null;
    String defaultLabelName = null;
    ArrayList<String> labels = new ArrayList();

    public PackedSwitchTask(DexInstructionParser instrParser, long base, long offset) {
        super(instrParser, base, offset);
    }

    @Override
    public boolean equals(DedexerTask o) {
        if (!(o instanceof PackedSwitchTask)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public void doTask(boolean isSecondPass) throws IOException {
        if (!isSecondPass) {
            if (this.jumpTable == null) {
                this.readJumpTable();
            }
            String switchLabelPrefix = "ps" + Long.toHexString(this.base) + "_";
            this.instrParser.placeTask(this.base, this);
            this.defaultLabelName = String.valueOf(switchLabelPrefix) + "default";
            this.instrParser.placeLabel(this.base + 6L, this.defaultLabelName);
            int i = 0;
            while (i < this.jumpTable.length) {
                long target = this.jumpTable[i];
                String labelName = String.valueOf(switchLabelPrefix) + Long.toHexString(target);
                this.instrParser.placeLabel(target, labelName);
                this.labels.add(labelName);
                ++i;
            }
            this.instrParser.placeTask(this.offset, this);
        }
    }

    @Override
    public void renderTask(long position) throws IOException {
        if (position == this.base) {
            this.instrParser.getCodeGenerator().renderPackedSwitch(this.reg, this.low, this.defaultLabelName, this.labels);
        } else if (position == this.offset) {
            long endTablePosition = this.instrParser.getFilePosition() + this.tableLength;
            this.instrParser.setFilePosition(endTablePosition);
        }
    }

    public void setReg(int reg) {
        this.reg = reg;
    }

    public long[] readJumpTable() throws IOException {
        long origPos = this.instrParser.getFilePosition();
        this.instrParser.setFilePosition(this.offset);
        long tableBasePos = this.instrParser.getFilePosition();
        int tableType = this.instrParser.read16Bit();
        if (tableType != 256) {
            throw new IOException("Invalid packed-switch table type (0x" + Integer.toHexString(tableType) + ") at offset 0x" + Long.toHexString(this.instrParser.getFilePosition() - 2L));
        }
        int tableElements = this.instrParser.read16Bit();
        this.low = this.instrParser.readSigned32Bit();
        this.jumpTable = new long[tableElements];
        int i = 0;
        while (i < tableElements) {
            int targetOffset = this.instrParser.readSigned32Bit();
            this.jumpTable[i] = this.base + (long)(targetOffset * 2);
            ++i;
        }
        this.tableLength = this.instrParser.getFilePosition() - tableBasePos;
        this.instrParser.setFilePosition(origPos);
        return this.jumpTable;
    }

    @Override
    public boolean getParseFlag(long position) {
        return position == this.offset;
    }
}

