/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexParser;
import hu.uw.pallergabor.dedexer.DexSignatureBlock;
import java.io.IOException;

public class DexMethodHeadParser
extends DexParser {
    private int registersSize;
    private int inputParameters;
    private int outputParameters;
    private int triesSize;
    private long debugOffset;
    private long instructionsSize;
    private long instructionBase;
    private DexSignatureBlock dexSignatureBlock;

    @Override
    public void parse() throws IOException {
        this.setDexOptimizationData(this.dexSignatureBlock.getDexOptimizationData());
        this.registersSize = this.read16Bit();
        this.dump("registers size: " + this.registersSize);
        this.inputParameters = this.read16Bit();
        this.dump("input arguments: " + this.inputParameters);
        this.outputParameters = this.read16Bit();
        this.dump("output arguments: " + this.outputParameters);
        this.triesSize = this.read16Bit();
        this.dump("try block size: " + this.triesSize);
        this.debugOffset = this.readFileOffset();
        this.dump("debug info offset: 0x" + Long.toHexString(this.debugOffset));
        this.instructionsSize = this.read32Bit();
        this.dump("instruction block size: " + this.instructionsSize);
        this.instructionBase = this.file.getFilePointer();
        this.dump("method block: 0x" + Long.toHexString(this.instructionBase) + "-0x" + Long.toHexString(this.getInstructionEnd()));
        this.dump("next block starts at: 0x" + Long.toHexString(this.getNextBlockOffset()));
    }

    public void setDexSignatureBlock(DexSignatureBlock dexSignatureBlock) {
        this.dexSignatureBlock = dexSignatureBlock;
    }

    public int getRegistersSize() {
        return this.registersSize;
    }

    public int getInputParameters() {
        return this.inputParameters;
    }

    public int getOutputParameters() {
        return this.outputParameters;
    }

    public int getTriesSize() {
        return this.triesSize;
    }

    public long getDebugOffset() {
        return this.debugOffset;
    }

    public long getInstructionBase() {
        return this.instructionBase;
    }

    public long getInstructionEnd() {
        return this.instructionBase + 2L * this.instructionsSize;
    }

    public long getNextBlockOffset() {
        long off = this.getInstructionEnd();
        if (off % 4L > 0L) {
            off = (off / 4L + 1L) * 4L;
        }
        return off;
    }
}

